/*!
\file
\brief check how the structure is processed


 */

#include <stat/emix.h>
#include <estim/particles.h>
#include <estim/kalman.h>
#include <mpdm/arx_agent.h>


using namespace bdm;

#ifdef MEX
#include <mex/mex_parser.h>
#include <mex/mex_function.h>

void mexFunction ( int n_output, mxArray *output[], int n_input, const mxArray *input[] ) {
	// Check the number of inputs and output arguments
	if ( n_input<1 ) mexErrMsgTxt ( "Usage:\n"
		                                "instance=class_defaults(struct)\n"
		                                "  struct              % configuration structure of a class\n"
		                                "output:\n"
		                                "  the same structure filled with the defaults.\n\n"
		                                "This operation is usefull for obtaining info about a class construction" );

	RV::clear_all();
	//CONFIG
	UImxArray Cfg(input[0]);
	shared_ptr<root> r=UI::build<root>(Cfg);
	
	if ( n_output<1 ) mexErrMsgTxt ( "No output - nothing to do!" );
	UImxArray Ret;
	UI::save(r, Ret.getRoot());
	
	output[0] = Ret.create_mxArray();
}
#endif
