/*!
  \file
  \brief Generating stress test agenda from random data.
  \author Vaclav Barta.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef ADDITIVE_GENERATOR_H
#define ADDITIVE_GENERATOR_H

#include "itpp_ext.h"
#include "generator.h"

/*! Iteratively adds squared random vector to a random matrix.
 */
class additive_generator : public generator {
private:
	itpp::mat a;
	itpp::mat v2;
	double lambda;

public:
	additive_generator() : lambda ( 0.5 ) { }

	itpp::mat next();

	//! Load from structure with elements:
	//!  \code
	//! { size = 7; // size (rows == cols) of the generated matrix
	//!   lambda = 0.5; // weight of the added vector
	//! }
	//! \endcode
	//! size is mandatory, lambda optional (with default as shown).
	void from_setting ( const Setting &set );
};

#endif
