#include "stat/discrete.h"
#include "../mat_checks.h"
#include "UnitTest++.h"

const double epsilon = 0.00001;

using namespace bdm;

TEST ( rectangular_support_test ) {
	rectangular_support rs;
	CHECK_EQUAL ( rs.first_vec(), vec ( 0 ) );

	Array<vec> range ( 2 );
	range ( 0 ) = vec ( "0 1" );
	range ( 1 ) = vec ( "-1 1" );
	ivec gridsize ( 2 );
	gridsize ( 0 ) = 10;
	gridsize ( 1 ) = 20;
	rs.set_parameters ( range, gridsize );
	CHECK_EQUAL ( 200, rs.points() );

	vec v = rs.get_vec ( ivec ( "1 2" ) );
	CHECK_CLOSE ( vec ( "0.15 -0.75" ), v, epsilon );
}

