#include <itpp/itbase.h>
#include "libBM.h"
#include "../itpp_ext.h"

using namespace itpp;

using std::cout;

void RV::init( ivec in_ids, Array<std::string> in_names, ivec in_sizes, ivec in_times ) {
	//
	int i;
	len = in_ids.length();
	//PRUDENT_MODE
	// All vetors should be of same length
	if ( 	 ( len != in_ids.length() ) || \
	        ( len != in_names.length() ) || \
	        ( len != in_sizes.length() ) || \
	        ( len != in_times.length() )) {
		it_error( "RV::RV inconsistent length of input vectors." );
	}

	ids = in_ids;
	names = in_names;
	sizes = in_sizes;
	times = in_times;
	tsize = 0;
	for(i=0;i<len;i++){tsize+=sizes(i);}
};

RV::RV ( ivec in_ids, Array<std::string> in_names, ivec in_sizes, ivec in_times ) {
	init ( in_ids, in_names, in_sizes, in_times );
}

RV::RV () : tsize(0),len(0){};

void RV::add (const RV &rv2) {
	// TODO
	tsize+=rv2.tsize;
	len +=rv2.len;
	ids=concat(ids,rv2.ids);
	sizes=concat(sizes,rv2.sizes);
	times=concat(times,rv2.times);
	names=concat(names,rv2.names);
//	return *this;
};

RV::RV ( ivec in_ids ) {
	
	len = in_ids.length();
	Array<std::string> A( len );
	std::string rvstr = "rv";

	for ( int i = 0; i < len;i++ ) {
		A( i ) = rvstr + to_str(i);
	}

	init ( in_ids, A, ones_i( len ), zeros_i( len ) );
}

RV RV::subselect(ivec ind){
	return RV(ids(ind), names(to_Arr(ind)), sizes(ind), times(ind));
}

void RV::t(int delta){ times +=delta;}

RV RV::operator()(ivec ind){
	return RV(ids(ind), names(to_Arr(ind)), sizes(ind), times(ind));
}

std::ostream &operator<<( std::ostream &os, const RV &rv ) {

	for ( int i = 0; i < rv.len ;i++ ) {
		os << rv.ids( i ) << "(" << rv.sizes( i ) << ")" <<  // id(size)=
		"=" << rv.names( i )  << "_{"  << rv.times( i ) << "}; "; //name_{time}
	}
	return os;
}

ivec RV::indexlist(){
	ivec indlist(tsize);
	int i;
	int pos = 0;
	for(i=0;i<len;i++){
		indlist.set_subvector(pos,pos+sizes(i)-1, ids(i));
	}
	return indlist;
}

RV concat(const RV &rv1, const RV &rv2 ){
	RV pom = rv1;
	pom.add(rv2); 
	return pom;
}
