/*!
  \file
  \brief DataSource for experiments with Aimsun
  \author Jan Prikryl.

*/
#include <base/loggers.h>

/* WIN32 stuff removed */
using namespace bdm;


//! Simulator of traffic - AIMSUN
class AimsunDS : public DS
{

public:
    //! Constructor with fixed sampling period
    AimsunDS ();

    //! Get measurements and signal plans from ELS3 controllers
    void getdata ( vec &dt ) const;

    //! Write new signal plans to ELS3
    void write ( vec &ut );

    //! Wait for new data and copy them out to local buffers
    void step();

	//! number of steps
	int max_length() {return 960;}
};
