function pmsm_ildp3
%verze ildp algoritmu s uvazovanim P (v logaritmu) pro PMSM motor
%rozsirena verze o diag P v pi aproximaci u
tic

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %pocatecni konstanty
   
    Iterace = 5; %iterace
    K = 50; %casy
    N = 50; %vzorky

    %konstanty motoru
    %Rs = 0.28;
    %Ls = 0.003465;
    %PSIpm = 0.1989;
    %kp = 1.5;
    %p = 4.0;
    %J = 0.04;
    DELTAt = 0.000125;

    %upravene konstanty
    Ca = 0.9898;
    Cb = 0.0072;
    Cc = 0.0361;
    Cd = 1.0;
    Ce = 0.0149;

    %omezeni rizeni
    cC1 = 100;
%     cLb = -50;
%     cUb = 50;

    %presnost mereni proudu
    deltaI = 0.085;

    %matice
    %kovariancni matice Q a R
    mQ = diag([0.0013 0.0013 5.0e-6 1.0e-10]);
    mR = diag([0.0006 0.0006]);
    
    %matice pro vypocet
    %matice A zavisla na parametrech
    mA = zeros(4);
    mA(1,1) = Ca;
    mA(2,2) = Ca;
    mA(3,3) = Cd;
    mA(4,4) = 1;
    mA(4,3) = DELTAt;

    %macite C konstantni
    mC = [ 1 0 0 0; 0 1 0 0];    

    %pozadovana hodnota otacek
    omega_t_stripe = 1.0015;    
    
    %penalizace za vstupy
    cPenPsi = 0;%0.000009;
   
    %pocatecni hodnoty
    X0 = [0; 0; 1; pi/2];
    Y0 = [0; 0];
    P0 = diag([0.01 0.01 0.01 0.01]);
    
    h_bel = 0;
    h_beldx = [0; 0; 0; 0; 0; 0];
    h_beldxdx = zeros(4);
           
    %velikost okoli pro lokalni metodu
%     rhoi = 0.0001;
%     rhoo = 0.00015;
%     rhot = 0.00005;
%     rhop = 0.0001;
    rhoi = 1.5;
    rhoo = 1.5;
    rhot = 1.5;
    rhop = 1.5;
    
    %zvetseni hamiltonianu pro minimalizace
%     mag = 1000;
    mag = 5;
    
    %prepinac sumu on/off
    noise = 1;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %globalni promenne

    Kpi_alfa = -0.2*ones(1, K); %konstanty aproximace slozky rizeni u_alfa
    Kpi_beta = 0.01*ones(1, K); %konstanty aproximace slozky rizeni u_beta    
%     Kpi_alfa = ones(1, K); %konstanty aproximace slozky rizeni u_alfa
%     Kpi_beta = ones(1, K); %konstanty aproximace slozky rizeni u_beta 
%     Kpi_alfa = zeros(4, K); %konstanty aproximace slozky rizeni u_alfa
%         Kpi_alfa(1, :) = 1000*Cc*Ce*ones(1, K);
%         Kpi_alfa(2, :) = 1000*Cc*Ce*ones(1, K);
%         
%     Kpi_beta = zeros(4, K); %konstanty aproximace slozky rizeni u_beta
%         Kpi_beta(1, :) = Cc*Ce*ones(1, K);
%         Kpi_beta(2, :) = Cc*Ce*ones(1, K);
    Kpi = ones(9, K);
        
        
    Wv = zeros(25, K); %konstanty aproximace Bellmanovy fce
    
    Xkn = zeros(4, K, N); % X = [i_alfa, i_beta, omega, theta]
    Ykn = zeros(2, K, N); % Y = [i_alfa, i_beta]
    Pkn = zeros(4, 4, K, N); % P = N vzorku posloupnosti K matic 4x4
    
    mKy = zeros(4, 2); % K = pomocna matice pro vypocet
    mRy = zeros(2, 2); % R = pomocna matice pro vypocet
    
    Xstripe = zeros(4, K); 
    Pstripe = zeros(4, 4, K);
  
    Epsilon = zeros(6, N); %globalni promena pro vypocet Bellmanovy fce z odchylek (X - Xprum)

    gka = 0; %globalni promenna pro prenos casu k
    gnu = 0; %globalni promenna pro prenos vzorku n
    
    Uopt2 = zeros(2, N);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %hlavni iteracni smycka
    for i = 1:Iterace,

        disp(['Iterace: ', num2str(i)]);
       %generovani stavu
       for n = 1:N,
            Xkn(:, 1, n) = X0; 
            Ykn(:, 1, n) = Y0;
            Pkn(:, :, 1, n) = P0;
            
            for k = 1:K-1,
               Uk = uPi(k, Xkn(:, k, n), Pkn(:, :, k, n));

               mRy = mC * Pkn(:, :, k, n) * mC' + mR;
               mKy = Pkn(:, :, k, n) * mC' / mRy;
               Xkn(:, k+1, n) = fceG(Xkn(:, k, n), Uk) - mKy * (Ykn(:, k, n) - fceH(Xkn(:, k, n))) + noise * sqrtm(mQ) * randn(4, 1);%+gauss sum s rozptylem odmocnina mQ
               Ykn(:, k+1, n) = round(Xkn(1:2, k+1, n) / deltaI) * deltaI; %X kopie do Y se vzorkovanim 0.085               
               mA(1, 3) = Cb * sin(Xkn(4, k, n));
               mA(1, 4) = Cb * Xkn(3, k, n) * cos(Xkn(4, k, n));
               mA(2, 3) = - Cb * cos(Xkn(4, k, n));
               mA(2, 4) = Cb * Xkn(3, k, n) * sin(Xkn(4, k, n));
               mA(3, 1) = - Ce * sin(Xkn(4, k, n));
               mA(3, 2) = Ce * cos(Xkn(4, k, n));
               mA(3, 4) = - Ce * (Xkn(2, k, n) * sin(Xkn(4, k, n)) + Xkn(1, k, n) * cos(Xkn(4, k, n)));
               Pkn(:, :, k+1, n) = mA * (Pkn(:, :, k, n) - Pkn(:, :, k, n) * mC' * inv(mRy) * mC * Pkn(:, :, k, n)) * mA' + mQ;
            end            
       end
       Xstripe = mean(Xkn, 3);       
       Pstripe = mean(Pkn, 4);
                 
       for k = K-1:-1:1,
            gka = k;
            
%             1]
            for n = 1:N,
               %krive okoli
               Xkn(1, k, n) = Xstripe(1, k) + rhoi*randn();
               Xkn(2, k, n) = Xstripe(2, k) + rhoi*randn();  
               Xkn(3, k, n) = Xstripe(3, k) + rhoo*randn();
               Xkn(4, k, n) = Xstripe(4, k) + rhot*randn();  
               
               Ykn(:, k, n) = round(Xkn(1:2, k, n) / deltaI) * deltaI;

               Pkn(:, :, k, n) = Pstripe(:, :, k) .* exp(rhop*randn(4));                 
            end  
            
%             2]
            for n = 1:N,
               gnu = n; 
                [Uopt2(:, n), Hmin(n)] = fmincon(@Hamilt, uPi(k, Xkn(:, k, n),Pkn(:, :, k, n)), [], [], [], [], [], [], @Cond2, optimset('GradConstr','on','Display','notify','Algorithm','active-set'));                
%                 Uopt2(1,n)=sin(2*pi/20*k);
%                 Z = zeros(101,101);
%                 ii = 0;
%                 jj = 0;
%                 for ii = -50:50,
%                     for jj = -50:50,
%                         Z(ii+51,jj+51) = Hamilt([ii,jj]);
%                     end
%                 end
%                 surf(Z);
            end
            
%             3]
            for n = 1:N, 
               Vn(n) = DELTAt*Hmin(n)/mag + Vtilde(k+1, Xkn(:, k, n), Pkn(:, :, k, n)); 
               
            end
            
%             4] 
            %urceni aproximace V Bellmanovy funkce            
            for n = 1:N,
                Epsilon(1:4, n) = Xkn(1:4, k, n) - Xstripe(1:4, k);
                tpdiag = diag(Pkn(:, :, k, n) ./ Pstripe(:, :, k));
                Epsilon(5:6, n) = tpdiag(3:4);
            end
            mFi = matrixFi(Epsilon);
            FiFiTInvFi = (mFi*mFi')\mFi;
            Wv(:,k) = FiFiTInvFi * Vn';
            
            %urceni aproximace pi rizeni u
            Kpi_alfa(k) = mean(Uopt2(1,:));                
            Kpi_beta(k) = mean(Uopt2(2,:));    
%             mPsi = ones(N,1);
%             PsiPsiTInvPsi = (mPsi'*mPsi)\mPsi';             
%             Kpi_alfa(:, k) = PsiPsiTInvPsi * Uopt2(1,:)';   
%             
%             mPsi = ones(N,1);
%             PsiPsiTInvPsi = (mPsi'*mPsi)\mPsi';             
%             Kpi_beta(:, k) = PsiPsiTInvPsi * Uopt2(2,:)';
%              mPsi = [sin(squeeze(Xkn(4, k, :))),...1
%                     cos(squeeze(Xkn(4, k, :))),...2
%                     (sin(squeeze(Xkn(4, k, :))).^2),...3
%                     (cos(squeeze(Xkn(4, k, :))).^2)];%4
%             PsiPsiTInvPsi = (mPsi'*mPsi)\mPsi';             
%             Kpi_alfa(:, k) = PsiPsiTInvPsi * Uopt2(1,:)';   
%             
%             mPsi = [sin(squeeze(Xkn(4, k, :))),...1
%                     cos(squeeze(Xkn(4, k, :))),...2
%                     (sin(squeeze(Xkn(4, k, :))).^2),...3
%                     (cos(squeeze(Xkn(4, k, :))).^2)];%4
%             PsiPsiTInvPsi = (mPsi'*mPsi)\mPsi';             
%             Kpi_beta(:, k) = PsiPsiTInvPsi * Uopt2(2,:)';
%             tmpUfi = squeeze(Xkn(4, k, :) + DELTAt*Xkn(3, k, :));
%             tmpUamp = sqrt(Uopt2(1,:).^2 + Uopt2(2,:).^2)';
%             mPsi = [Cd*Cd*squeeze(Xkn(3, k, :)),...1
%                     Cd*Ce*squeeze(Xkn(2, k, :).*cos(Xkn(4, k, :))),...2
%                     - Cd*Ce*squeeze(Xkn(1, k, :).*sin(Xkn(4, k, :))),...3
%                     Ce*Ca*squeeze(Xkn(2, k, :)).*cos(tmpUfi),...4
%                     - Ce*Cb*squeeze(Xkn(3, k, :).*cos(Xkn(4, k, :))).*cos(tmpUfi),...5
%                     Ce*Ca*squeeze(Xkn(1, k, :)).*sin(tmpUfi),...6
%                     Ce*Cb*squeeze(Xkn(3, k, :).*sin(Xkn(4, k, :))).*sin(tmpUfi),...7
%                     Ce*Cc*squeeze( (cos(tmpUfi)).^2 - (sin(tmpUfi)).^2 ).*tmpUamp,...8                    
%                     tmpUamp];%9
%             PsiPsiTInvPsi = (mPsi'*mPsi)\mPsi';             
%             Kpi(:, k) = PsiPsiTInvPsi * (omega_t_stripe*ones(N, 1));          
       end       
    end
   
    %%%%%%%%%%%
    toc
%     keyboard
    Kpi_alfa
    Kpi_beta
    %vykresleni grafu
                clf
                subplot(3,4,3);                        
                plot(1:K,omega_t_stripe*ones(1,K));
                
                Ukn = zeros(2, K, N);
                for n = 1:N,
                    Xkn(:, 1, n) = X0; 
                    Ykn(:, 1, n) = Y0;
                    Pkn(:, :, 1, n) = P0;                    
                    for k = 1:K-1,
                       Ukn(:, k, n) = uPi(k, Xkn(:, k, n), Pkn(:, :, k, n));
                       mRy = mC * Pkn(:, :, k, n) * mC' + mR;
                       mKy = Pkn(:, :, k, n) * mC' / mRy;
                       Xkn(:, k+1, n) = fceG(Xkn(:, k, n), Ukn(:, k, n)) - mKy * (Ykn(:, k, n) - fceH(Xkn(:, k, n))) + noise * sqrtm(mQ) * randn(4, 1);%+gauss sum s rozptylem odmocnina mQ
                       Ykn(:, k+1, n) = round(Xkn(1:2, k+1, n) / deltaI) * deltaI; %X kopie do Y se vzorkovanim 0.085             
                       mA(1, 3) = Cb * sin(Xkn(4, k, n));
                       mA(1, 4) = Cb * Xkn(3, k, n) * cos(Xkn(4, k, n));
                       mA(2, 3) = - Cb * cos(Xkn(4, k, n));
                       mA(2, 4) = Cb * Xkn(3, k, n) * sin(Xkn(4, k, n));
                       mA(3, 1) = - Ce * sin(Xkn(4, k, n));
                       mA(3, 2) = Ce * cos(Xkn(4, k, n));
                       mA(3, 4) = - Ce * (Xkn(2, k, n) * sin(Xkn(4, k, n)) + Xkn(1, k, n) * cos(Xkn(4, k, n)));
                       Pkn(:, :, k+1, n) = mA * (Pkn(:, :, k, n) - Pkn(:, :, k, n) * mC' * inv(mRy) * mC * Pkn(:, :, k, n)) * mA' + mQ;  
                    end
                    
                        hold all
                        subplot(3,4,1);
                        title('X:i_{\alpha}')
                        plot(1:K,Xkn(1,:,n))
                        
                        hold all
                        subplot(3,4,2);
                        title('X:i_{\beta}')
                        plot(1:K,Xkn(2,:,n))
                        
                        hold all
                        subplot(3,4,3);
                        title('X:\omega')
                        plot(1:K,Xkn(3,:,n))
                        
                        hold all
                        subplot(3,4,4);
                        title('X:\theta')
                        plot(1:K,Xkn(4,:,n))
                        
                        hold all
                        subplot(3,4,5);
                        title('Y:i_{\alpha}')
                        plot(1:K,Ykn(1,:,n))
                        
                        hold all
                        subplot(3,4,6);
                        title('Y:i_{\beta}')
                        plot(1:K,Ykn(2,:,n))
                        
                        hold all
                        subplot(3,4,7);
                        title('u_{\alpha}')
                        plot(1:K,Ukn(1,:,n))
                        
                        hold all
                        subplot(3,4,8);
                        title('u_{\beta}')
                        plot(1:K,Ukn(2,:,n))
                        
                        hold all
                        subplot(3,4,9);
                        title('P(1, 1)')
                        plot(1:K,squeeze(Pkn(1, 1, :, n)))
                        
                        hold all
                        subplot(3,4,10);
                        title('P(2, 2)')
                        plot(1:K,squeeze(Pkn(2, 2, :, n)))
                        
                        hold all
                        subplot(3,4,11);
                        title('P(3, 3)')
                        plot(1:K,squeeze(Pkn(3, 3, :, n)))
                        
                        hold all
                        subplot(3,4,12);
                        title('P(4, 4)')
                        plot(1:K,squeeze(Pkn(4, 4, :, n)))
                end
                
                figure
                
                for n = 1:N,
                    Xkn(:, 1, n) = X0;                                         
                    for k = 1:K-1,
                       Ukn(:, k, n) = uPi(k, Xkn(:, k, n), zeros(4));                       
                       Xkn(:, k+1, n) = fceG(Xkn(:, k, n), Ukn(:, k, n)) + noise * sqrtm(mQ) * randn(4, 1);                         
                    end
                    
                        hold all
                        subplot(2,3,1);
                        title('X:i_{\alpha}')
                        plot(1:K,Xkn(1,:,n))
                        
                        hold all
                        subplot(2,3,2);
                        title('X:i_{\beta}')
                        plot(1:K,Xkn(2,:,n))
                        
                        hold all
                        subplot(2,3,3);
                        title('X:\omega')
                        plot(1:K,Xkn(3,:,n))
                        
                        hold all
                        subplot(2,3,4);
                        title('X:\theta')
                        plot(1:K,Xkn(4,:,n))                       
                        
                        hold all
                        subplot(2,3,5);
                        title('u_{\alpha}')
                        plot(1:K,Ukn(1,:,n))
                        
                        hold all
                        subplot(2,3,6);
                        title('u_{\beta}')
                        plot(1:K,Ukn(2,:,n))         
                        
                end
               
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %pomocne funkce
    
    function [val_uPi] = uPi(k_uPi, x_uPi, p_uPi)
        val_uPi = zeros(2, 1);
        val_uPi(1) = Kpi_alfa(k_uPi); 
        val_uPi(2) = Kpi_beta(k_uPi);     
%         val_uPi(1) = Kpi_alfa(1, k_uPi)*sin(x_uPi(4)) + Kpi_alfa(2, k_uPi)*cos(x_uPi(4)) + Kpi_alfa(3, k_uPi)*(sin(x_uPi(4)))^2 + Kpi_alfa(4, k_uPi)*(cos(x_uPi(4)))^2; 
%         val_uPi(2) = Kpi_beta(1, k_uPi)*sin(x_uPi(4)) + Kpi_beta(2, k_uPi)*cos(x_uPi(4)) + Kpi_beta(3, k_uPi)*(sin(x_uPi(4)))^2 + Kpi_beta(4, k_uPi)*(cos(x_uPi(4)))^2; 
%         tmpfi = x_uPi(4) + DELTAt*x_uPi(3);
%         tmpw = ( omega_t_stripe - Cd*(Kpi(1, k_uPi)*Cd*x_uPi(3) + Kpi(2, k_uPi)*Ce*x_uPi(2)*cos(x_uPi(4)) - Kpi(3, k_uPi)*Ce*x_uPi(1)*sin(x_uPi(4)))...
%                - Ce*( (Kpi(4, k_uPi)*Ca*x_uPi(2) - Kpi(5, k_uPi)*Cb*x_uPi(3)*cos(x_uPi(4)))*cos(tmpfi)...
%                      -(Kpi(6, k_uPi)*Ca*x_uPi(1) + Kpi(7, k_uPi)*Cb*x_uPi(3)*sin(x_uPi(4)))*sin(tmpfi) ) ) /...
%                (Kpi(8, k_uPi)*Ce*Cc*( (cos(tmpfi))^2 - (sin(tmpfi))^2 ) + Kpi(9, k_uPi));
%            
%         if(tmpw > cC1)
%             tmpw = cC1;
%         elseif(tmpw < - cC1)
%             tmpw = -cC1;
%         end
%         val_uPi(1) = tmpw*sin(tmpfi);
%         val_uPi(2) = tmpw*cos(tmpfi);
    end
 
    function [val_ham] = Hamilt(u_ham)             
               mRy = mC * Pkn(:, :, gka, gnu) * mC' + mR;
               mKy = Pkn(:, :, gka, gnu) * mC' / mRy;
               tXkn = fceG(Xkn(:, gka, gnu), u_ham) - mKy * (Ykn(:, gka, gnu) - fceH(Xkn(:, gka, gnu)));
               mA(1, 3) = Cb * sin(Xkn(4, gka, gnu));
               mA(1, 4) = Cb * Xkn(3, gka, gnu) * cos(Xkn(4, gka, gnu));
               mA(2, 3) = - Cb * cos(Xkn(4, gka, gnu));
               mA(2, 4) = Cb * Xkn(3, gka, gnu) * sin(Xkn(4, gka, gnu));
               mA(3, 1) = - Ce * sin(Xkn(4, gka, gnu));
               mA(3, 2) = Ce * cos(Xkn(4, gka, gnu));
               mA(3, 4) = - Ce * (Xkn(2, gka, gnu) * sin(Xkn(4, gka, gnu)) + Xkn(1, gka, gnu) * cos(Xkn(4, gka, gnu)));
               tPkn = mA * (Pkn(:, :, gka, gnu) - Pkn(:, :, gka, gnu) * mC' * inv(mRy) * mC * Pkn(:, :, gka, gnu)) * mA' + mQ;                  
               tf = zeros(6,1);
               tf(1:4) = tXkn;
               tfpdiag = diag(tPkn);
               tf(5:6) = tfpdiag(3:4);
               
%                loss = (tXkn(3) - omega_t_stripe)^2;
%                loss = (Cd * Xkn(3, gka, gnu) + Ce * ((Ca * Xkn(2, gka, gnu) - Cb * Xkn(3, gka, gnu) * cos(Xkn(4, gka, gnu)) + Cc * u_ham(2)) * cos(Xkn(4, gka, gnu)) - (Ca * Xkn(1, gka, gnu) + Cb * Xkn(3, gka, gnu) * sin(Xkn(4, gka, gnu)) + Cc * u_ham(1)) * sin(Xkn(4, gka, gnu))) - omega_t_stripe)^2;
%                if(gka == 1)
%                  loss = (tXkn(3) - omega_t_stripe)^2;
%                else
%                  loss = (Cd * Xkn(3, gka, gnu) + Ce * ((Ca * Xkn(2, gka-1, gnu) - Cb * Xkn(3, gka-1, gnu) * cos(Xkn(4, gka-1, gnu)) + Cc * u_ham(2)) * cos(Xkn(4, gka, gnu)) - (Ca * Xkn(1, gka-1, gnu) + Cb * Xkn(3, gka-1, gnu) * sin(Xkn(4, gka-1, gnu)) + Cc * u_ham(1)) * sin(Xkn(4, gka, gnu))) - omega_t_stripe)^2;  
%                end
%                loss = (Cd * tXkn(3) + Ce * ((Ca * Xkn(2, gka, gnu) - Cb * Xkn(3, gka, gnu) * cos(Xkn(4, gka, gnu)) + Cc * u_ham(2)) * cos(tXkn(4)) - (Ca * Xkn(1, gka, gnu) + Cb * Xkn(3, gka, gnu) * sin(Xkn(4, gka, gnu)) + Cc * u_ham(1)) * sin(tXkn(4))) - omega_t_stripe)^2;  


%                loss = loss + cPenPsi*(u_ham(1)^2 + u_ham(2)^2);
               loss = ( Cd*(Cd*Xkn(3, gka, gnu)...
                          + Ce*Xkn(2, gka, gnu)*cos(Xkn(4, gka, gnu))...
                          - Ce*Xkn(1, gka, gnu)*sin(Xkn(4, gka, gnu)))...
                      + Ce*( (Ca*Xkn(2, gka, gnu) - Cb*Xkn(3, gka, gnu)*cos(Xkn(4, gka, gnu)) )*cos(Xkn(4, gka, gnu)+DELTAt*Xkn(3, gka, gnu))...
                            -(Ca*Xkn(1, gka, gnu) + Cb*Xkn(3, gka, gnu)*sin(Xkn(4, gka, gnu)) )*sin(Xkn(4, gka, gnu)+DELTAt*Xkn(3, gka, gnu)))... 
                      + Ce*Cc*u_ham(2)*cos(Xkn(4, gka, gnu)+DELTAt*Xkn(3, gka, gnu))...
                      - Ce*Cc*u_ham(1)*sin(Xkn(4, gka, gnu)+DELTAt*Xkn(3, gka, gnu))...
                      - omega_t_stripe )^2;
               
               val_ham = mag*(loss + tf' * Vtilde_dx(gka+1, Xkn(:, gka, gnu), Pkn(:, :, gka, gnu)) + 1/2 * trace(mQ * Vtilde_dx_dx(gka+1)));
                                          
    end

    function [val_Vt] = Vtilde(k_Vt, x_Vt, p_Vt)
        if(k_Vt == K)
            val_Vt = h_bel;
        else
            Epsl = zeros(6, 1);            
            Epsl(1:4) = x_Vt(1:4) - Xstripe(1:4, k_Vt);
            tpdiag = diag(p_Vt ./ Pstripe(:, :, k));  
            Epsl(5:6) = tpdiag(3:4);               
            
            val_Vt = vectFi(Epsl)' * Wv(:,k_Vt);
        end
    end

    function [val_Vt] = Vtilde_dx(k_Vt, x_Vt, p_Vt)
        if(k_Vt == K)
            val_Vt = h_beldx;
        else
             Epsl = zeros(6, 1);            
             Epsl(1:4) = x_Vt(1:4) - Xstripe(1:4, k_Vt);
             tpdiag = diag(p_Vt ./ Pstripe(:, :, k));  
             Epsl(5:6) = tpdiag(3:4);
                
            val_Vt = difFi(Epsl)' * Wv(:,k_Vt);
        end
    end

    function [val_Fi] = vectFi(x_Fi)
        val_Fi = [ ...
                   1; ...			%1
                   x_Fi(1); ...			%Xi pro 1-4
                   x_Fi(2); ...
                   x_Fi(3); ...
                   x_Fi(4); ...
                   log(x_Fi(5)); ...		%ln Xi pro 5-8 tj diagonala matice Pt 4x4
                   log(x_Fi(6)); ...                   
                   x_Fi(1)^2; ...		%kvadraticke cleny jen v Xi 1-4 a kombinovane
                   x_Fi(1)*x_Fi(2); ...
                   x_Fi(1)*x_Fi(3); ...
                   x_Fi(1)*x_Fi(4); ...
                   x_Fi(1)*log(x_Fi(5)); ...
                   x_Fi(1)*log(x_Fi(6)); ...                   
                   x_Fi(2)^2; ...
                   x_Fi(2)*x_Fi(3); ...
                   x_Fi(2)*x_Fi(4); ...
                   x_Fi(2)*log(x_Fi(5)); ...
                   x_Fi(2)*log(x_Fi(6)); ...                   
                   x_Fi(3)^2; ...
                   x_Fi(3)*x_Fi(4); ...
                   x_Fi(3)*log(x_Fi(5)); ...
                   x_Fi(3)*log(x_Fi(6)); ...                   
                   x_Fi(4)^2; ...
                   x_Fi(4)*log(x_Fi(5)); ...
                   x_Fi(4)*log(x_Fi(6)); ...                   
                 ];
    end

    function [val_Fi] = matrixFi(x_Fi)
        val_Fi = [ ...
		   ones(1, N); ...			%1
           x_Fi(1, :); ...			%Xi pro 1-4
           x_Fi(2, :); ...
		   x_Fi(3, :); ...
           x_Fi(4, :); ...
           log(x_Fi(5, :)); ...		%ln Xi pro 5-8 tj diagonala matice Pt 4x4
           log(x_Fi(6, :)); ...		   	   
		   x_Fi(1, :).^2; ...		%kvadraticke cleny jen v Xi 1-4 a kombinovane
           x_Fi(1, :).*x_Fi(2, :); ...
           x_Fi(1, :).*x_Fi(3, :); ...
           x_Fi(1, :).*x_Fi(4, :); ...
 		   x_Fi(1, :).*log(x_Fi(5, :)); ...
           x_Fi(1, :).*log(x_Fi(6, :)); ...
           x_Fi(2, :).^2; ...
           x_Fi(2, :).*x_Fi(3, :); ...
           x_Fi(2, :).*x_Fi(4, :); ...
 		   x_Fi(2, :).*log(x_Fi(5, :)); ...
           x_Fi(2, :).*log(x_Fi(6, :)); ...           
           x_Fi(3, :).^2; ...
           x_Fi(3, :).*x_Fi(4, :); ...
 		   x_Fi(3, :).*log(x_Fi(5, :)); ...
           x_Fi(3, :).*log(x_Fi(6, :)); ...
           x_Fi(4, :).^2; ...
 		   x_Fi(4, :).*log(x_Fi(5, :)); ...
           x_Fi(4, :).*log(x_Fi(6, :)); ...           
                 ];

    end

    function [val_Fi] = difFi(x_Fi)
        val_Fi = [ ...
		   0 0 0 0 0 0; ...1			
           1 0 0 0 0 0; ...2			
           0 1 0 0 0 0; ...3
		   0 0 1 0 0 0; ...4
           0 0 0 1 0 0; ...5
           0 0 0 0 1/x_Fi(5) 0; ...6		
           0 0 0 0 0 1/x_Fi(6); ...7		   
		   2*x_Fi(1) 0 0 0 0 0; ...8		
           x_Fi(2) x_Fi(1) 0 0 0 0; ...9
           x_Fi(3) 0 x_Fi(1) 0 0 0; ...10
           x_Fi(4) 0 0 x_Fi(1) 0 0; ...11
 		   log(x_Fi(5)) 0 0 0 x_Fi(1)/x_Fi(5) 0; ...12
           log(x_Fi(6)) 0 0 0 0 x_Fi(1)/x_Fi(6); ...13           
           0 2*x_Fi(2) 0 0 0 0; ...14
           0 x_Fi(3) x_Fi(2) 0 0 0; ...15
           0 x_Fi(4) 0 x_Fi(2) 0 0; ...16
 		   0 log(x_Fi(5)) 0 0 x_Fi(2)/x_Fi(5) 0; ...17
           0 log(x_Fi(6)) 0 0 0 x_Fi(2)/x_Fi(6); ...18           
           0 0 2*x_Fi(3) 0 0 0; ...19
           0 0 x_Fi(4) x_Fi(3) 0 0; ...20
 		   0 0 log(x_Fi(5)) 0 x_Fi(3)/x_Fi(5) 0; ...21
           0 0 log(x_Fi(6)) 0 0 x_Fi(3)/x_Fi(6); ...22
           0 0 0 2*x_Fi(4) 0 0; ...23
 		   0 0 0 log(x_Fi(5)) x_Fi(4)/x_Fi(5) 0; ...24
           0 0 0 log(x_Fi(6)) 0 x_Fi(4)/x_Fi(6); ...25           
                 ];
    end

    function [valvt] = Vtilde_dx_dx(kin)
        if(kin == K)
           valvt = h_beldxdx;
        else
           valvt = Wv(8, kin)*diag([2 0 0 0]) +...
                   Wv(9, kin)*[0 1 0 0; 1 0 0 0; 0 0 0 0; 0 0 0 0] +...
                   Wv(10, kin)*[0 0 1 0; 0 0 0 0; 1 0 0 0; 0 0 0 0] +...
                   Wv(11, kin)*[0 0 0 1; 0 0 0 0; 0 0 0 0; 1 0 0 0] +... 
                   Wv(14, kin)*diag([0 2 0 0]) +...
                   Wv(15, kin)*[0 0 0 0; 0 0 1 0; 0 1 0 0; 0 0 0 0] +...
                   Wv(16, kin)*[0 0 0 0; 0 0 0 1; 0 0 0 0; 0 1 0 0] +...
                   Wv(19, kin)*diag([0 2 0 0]) +...
                   Wv(20, kin)*[0 0 0 0; 0 0 0 0; 0 0 0 1; 0 0 1 0] +...
                   Wv(23, kin)*diag([0 2 0 0]);
        end
    end
	
    function [c, ceq, GC, GCeq] = Cond2(x)
	c = x(1)*x(1) + x(2)*x(2) - cC1^2;
    ceq = [];
    GC = [2*x(1); 2*x(2)];
	GCeq = [];
    end

    function [x_ret] = fceG(x_in, u_in)
        x_ret = zeros(4, 1);
        x_ret(1) = Ca * x_in(1) + Cb * x_in(3) * sin(x_in(4)) + Cc * u_in(1);
        x_ret(2) = Ca * x_in(2) - Cb * x_in(3) * cos(x_in(4)) + Cc * u_in(2);
        x_ret(3) = Cd * x_in(3) + Ce * (x_in(2) * cos(x_in(4)) - x_in(1) * sin(x_in(4)));
        x_ret(4) = x_in(4) + x_in(3) * DELTAt;
    end

    function [y_ret] = fceH(x_in)
        y_ret = zeros(2, 1);
        y_ret(1) = x_in(1);
        y_ret(2) = x_in(2);
    end

end
