#!/usr/bin/python
# -*- coding: utf-8 -*-
import os
from pyplusplus import module_builder

#Creating an instance of class that will help you to expose your declarations
mb = module_builder.module_builder_t( [r"/home/smidl/work/git/mixpp/library/system/linux/itpp/itbase.h"]
                                      , gccxml_path=r"" 
                                      , working_directory=r"/home/smidl/work"
                                      , include_paths=['/home/smidl/work/git/mixpp/library/system/linux/itpp/base', '/home/smidl/work/git/mixpp/library/system/linux']
                                      , define_symbols=[] )
mb.decls( lambda decl: 'Array' in decl.name ).exclude()
mb.decls( lambda decl: 'Sparse' in decl.name ).exclude()
mb.decls( lambda decl: 'AR1' in decl.name ).exclude()
mb.decls( lambda decl: '<short>' in decl.name ).exclude()
mb.decls( lambda decl: '<float>' in decl.name ).exclude()
mb.decls( lambda decl: '<unsigned char>' in decl.name ).exclude()

mb.decls( lambda decl: '_data' in decl.name ).exclude()
mb.decls( lambda decl: 'GF2' in decl.name ).exclude()
mb.decls( lambda decl: 'bifstream' in decl.name ).exclude()
mb.decls( lambda decl: 'file_old' in decl.name ).exclude()


#Well, don't you want to see what is going on?
#mb.print_declarations()

#Creating code creator. After this step you should not modify/customize declarations.
mb.build_code_creator( module_name='itpp_ext' )

#Writing code to file.
mb.write_module( './itpp_ext.cpp' )
