#include "bdmroot.h"

//! Space of basic BDM structures
namespace bdm {
	
	//! a general utility transforming a comma-separated sequence of strings into an instance of Array<strings>
	Array<string> log_level_base::string2Array( const string &input )
	{
		string result = input;
		string::size_type loc;
		while( loc = result.find( ',' ), loc != string::npos )
			result[loc] = ' ';
		return Array<string>("{ " + result + " }" );
	}

	void UI_DBG (const  Setting &S, const string &spc, ostream &out =cout){
		const char *Name=S.getName();
		if ( Name!=NULL ) {out << spc << std::string ( Name );};
		Setting::Type T=S.getType();
		switch ( T ) {
			case Setting::TypeArray:
				out << endl;
				for ( int i=0;i<S.getLength();i++ ) {UI_DBG ( S[i], spc+" ", out);};
				break;
			case Setting::TypeList:
				out << endl;
				for ( int i=0;i<S.getLength();i++ ) {UI_DBG ( S[i], spc+" ", out );};
				break;
			case Setting::TypeGroup:
				out << endl;
				for ( int i=0;i<S.getLength();i++ ) {UI_DBG ( S[i], spc+" ", out );}
				break;
			case Setting::TypeInt:
				out << " = ";
				out << int ( S ) <<endl;
				break;
			case Setting::TypeFloat:
				out << " = ";
				out << double ( S ) <<endl;
				break;
			case Setting::TypeString:
				out << " = ";
				out << ( const char* ) ( S ) <<endl;
				break;
			case Setting::TypeBoolean:
				out << " = ";
				out << bool ( S ) <<endl;
				break;
			default: {out << "?";};
		};
	}
	
}
