/*!
  \file
  \brief Higher-level Objects - Participants
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef PARTICIPANTS_H
#define PARTICIPANTS_H


#include "bdmbase.h"
#include "../base/user_info.h"

namespace bdm {
/*!
* \brief Basic Participant

This object is an active unit with name and capability to store results

*/
class Participant : public root {
protected:
	//! name - ID of the participant 
	string name;
public:
	//! Empty constructor
	Participant(){}
	//! set name
	void set_name(const string &name0){name=name0;}
	//! Process data
	virtual void adapt(const vec &glob_dt){}
	/*! create message -- use exclusively this function
	Writes the following structure into \c msg:
	\code 
	to = A1;                      // recepients
	what = predictor;             // sort code
	data = message_body;          // data itself
	\endcode
	
	*/
	void create_message(Setting &msg,const string &to, const string &what, const root &data){
		Setting &m_to=msg.add("to",Setting::TypeString);
		m_to=to;
		Setting &m_what=msg.add("what",Setting::TypeString);
		m_what=what;
		//Setting &m_data=msg.add("data",Setting::TypeGroup);
		UI::save(&data, msg, "data");
	}	
	/*! Broadcast communication to the others. Add message(s) to the provided queue.
	*/
	virtual void broadcast(Setting& queue){}
	//! Receive one message from the queue
	virtual void receive(const Setting& msg){}
	//! Design control strategy
	virtual void act(vec &glob_ut){}
	//! Time step
	virtual void step(){}
	//! read only name
	void from_setting(const Setting& set){
		UI::get(name,set,"name",UI::compulsory);
	}
	void to_setting(Setting& set) const {
		UI::save(name,set,"name");
	}
	//!access function
	const string &_name() {return name;}
	//! register data source where to get data
	virtual void ds_register(const DS &ds){ }
	
};

}; //namespace

#endif // PARTICIPANTS_H
