class mexEpdf: public epdf{
	protected:
		mxArray *data;
	public:
		mexEpdf() {};
		void from_setting(const Setting &S)  {
			Setting &So=S["object"];
			data = (mxArray*)long(So);
		} 
		void validate() {
			mexCallMATLAB(1, &data, 0, 0, "validate");
			dim = mexCallMATLAB(1, &data, 0, 0, "dimension");
		}
		vec mean() const {
			mxArray *tmp;
			mexCallMATLAB(1, &tmp, 1, (mxArray **) &data, "mean");
			return mxArray2vec(tmp);
		}
		vec sample() const {
			mxArray *tmp;
			mexCallMATLAB(1, &tmp, 1, (mxArray **) &data, "sample");
			return mxArray2vec(tmp);
		}
		double evallog(const vec &dt) const {
			mxArray *tmp;
			mexCallMATLAB(1, &tmp, 1, (mxArray **) &data, "evallog");
			return mxArray2double(tmp);
		}
		vec variance() const {
			mxArray *tmp;
			mexCallMATLAB(1, &tmp, 1, (mxArray **) &data, "variance");
			return mxArray2vec(tmp);
		}
};
UIREGISTER(mexEpdf);