clear all
% name random variables
y = RV({'y'},1);
u1 = RV({'u1'},1);
u2 = RV({'u2'},1);

% create f(y_t| y_{t-3}, u_{t-1})
fy.class = 'mlnorm<ldmat>';
fy.rv    = y;
fy.rvc   = RVtimes([y,u1,u2], [-3, 0, 0]);
fy.A     = [0.5, -0.9, 0.9];
fy.const = 0;
fy.R     = 1e-2;

DS.class = 'PdfDS';
DS.pdf = fy;

% create ARX estimator
A1.class = 'ARX';
A1.rv = y;
A1.rgr = RVtimes([y,u1],[-3,0]) ; % correct structure is {y,y}
A1.log_level ='logbounds,logevidence';
A1.frg = 0.95;

A2=A1;
A2.rgr = RVtimes([y,u2],[-3,0]) ; % correct structure is {y,y}


C1.class = 'LQG_ARX';
C1.ARX = A1;
C1.Qu = 0.1*eye(1);
C1.Qy = 1*eye(1);
C1.yreq = 1;
C1.horizon = 100;

C2=C1;
C2.ARX = A2;

exper.Ndat=100;
exper.burnin=3;
exper.burn_pdf.class='enorm<chmat>';
exper.burn_pdf.mu=[0,0];
exper.burn_pdf.R=0.1*eye(2);


M= controlloop(DS,{C1,C2},exper);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       PLOTS

figure(1);
hold off
subplot(1,2,1);
plot(M.DS_y);
subplot(1,2,2);
plot(M.DS_u1); hold on;
plot(M.DS_u2); 

figure(2);
hold off
plot(M.Ctrl0_apost_mean_theta);
hold on
plot(M.Ctrl0_apost_ub_theta,':');
plot(M.Ctrl0_apost_lb_theta,':');
set(gca,'YLim',[-4,2]);

figure(3);
hold off
plot(M.Ctrl1_apost_mean_theta);
hold on
plot(M.Ctrl1_apost_ub_theta,':');
plot(M.Ctrl1_apost_lb_theta,':');
set(gca,'YLim',[-2,3]);
