class mexEpdf: public epdf{
	protected:
		mxArray *data;
	public:
		mexEpdf() {};
		void from_setting(const Setting &S)  {
			Setting &So=S["object"];
			data = (mxArray*)long(So);
		} 
		void validate() {
			mexCallMATLAB(0, 0, 1, &data,  "validate");
			mxArray *tmp;
			mexCallMATLAB(1, &tmp, 1, &data, "dimension");
			dim = mxArray2double(tmp);
		}
		vec mean() const {
			mxArray *tmp;
			mexCallMATLAB(1, &tmp, 1, (mxArray **) &data, "mean");
			return mxArray2vec(tmp);
		}
		vec sample() const {
			mxArray *tmp;
			mexCallMATLAB(1, &tmp, 1, (mxArray **) &data, "sample");
			return mxArray2vec(tmp);
		}
		double evallog(const vec &dt) const {
			mxArray *tmp;
			mxArray *in[2];
			in[0]=data;
			in[1]=mxCreateDoubleMatrix(dimension(),1,mxREAL);
			vec2mxArray(dt,in[1]);
			mexCallMATLAB(1, &tmp, 2, in, "evallog");
			return mxArray2double(tmp);
		}
		vec variance() const {
			mxArray *tmp;
			mexCallMATLAB(1, &tmp, 1, (mxArray **) &data, "variance");
			return mxArray2vec(tmp);
		}
};
UIREGISTER(mexEpdf);

