classdef mexLaplace < mexEpdf
    properties
      % from wikipedia
    	mu
    	b
    end
    methods
        function m=mean(p)
            m = p.mu;
        end
        function validate(p)
            if size(p.mu)<1 & (size(p.b)<1)
                error('incompatible mu and b');
            end
        end
        function dim=dimension(p)
            dim = size(p.mu,1);
        end
        function v=variance(p)
            v=2*p.b^2;
        end
        function l=evallog(p,x)
            l=-log(2*p.b)-abs(x-p.mu)/p.b;
        end
        function s=sample(p);
            v=-log(rand);%sample_exponential(0,1);
            z = randn;
            s = p.mu+p.b*sqrt(2*v)*z;
        end
    end
end