clear all
% name random variables
x = RV({'x'},2);


fx.class  = 'mgnorm<ldmat>';             
fx.rv     = x;             
fx.rvc    = RVtimes(x,-1);             
fx.g      = 'mexFunction';              % function is evaluated in matlab
fx.g.function = 'test_function';         % name of the matlab function to evaluate
fx.g.dim  = 2;                          % expected dimension of output
fx.g.dimc = 2;                          % expected dimension of input
fx.R      = eye(2);                     % variance R


% create DS
DS.class = 'PdfDS';
DS.pdf.class  = 'mprod';
DS.pdf.pdfs  = {fx, fu};
DS.init_rv = RVtimes([x], [-1]);
DS.init_values = [0.1, 0.2];

experiment.ndat=100;

M=simulator(DS,experiment);
%M=estimator(DS,{},experiment);

%%% store results
Data=[M.DS_dt_y'; M.DS_dt_u'];
drv = RVjoin([y,u]);
true_theta=[fy.A fy.const]; 
true_R=[fy.R]; 
save pdfds_results Data drv y u true_theta true_R