x = RV('x',2);
y = RV('y',2);

g.class = 'mexFnc';
g.dim = 2;
g.dimc = 2;
g.function = 'test_function';

h.class = 'linfn';
h.A     = eye(2);
h.B     = [1;0];

fx.class = 'mgnorm<chmat>';
fx.R = [0.3 -0.2; -0.2 0.5];
fx.g = g;
fx.rv = x;
fx.rvc = RVtimes(x,-1);

fy.class = 'mgnorm<chmat>';
fy.R = 0.1*eye(2);
fy.g = h;
fy.rv = y;
fy.rvc = x;


%%%%%% Data generator
DS.class   = 'PdfDS';
DS.pdf.class     = 'mprod';
DS.pdf.pdfs      = {fy,fx};
DS.init_rv = RVtimes(x,-1);
DS.init_values = [.2,.3]';

%%%%% Estimator
A.class = 'ARX';
A.rv = y;
A.rgr = RV({});
A.rv_param = RV('R',4);
A.dimx=2;
A.constant = 0;
A.frg=0.99;

A2=A;
A2.rv_param = RV('Q',4);
A2.rv=x;

E.class = 'MPF_ARXg';
E.g = g;
E.h = h;
E.rvc = x;
E.arxo = A;
E.arxp = A2;
E.prior.class = 'enorm<ldmat>';
E.prior.mu = [0.2;0.3];
E.prior.R = 0.1*eye(2);
E.n = 100;
E.res_threshold = 1.0;


exper.ndat = 2000;
M = estimator(DS,{E},exper);
%%%%%% ARX estimator conditioned on frg

% plot

figure(1);
hold off
plot(M.Est0_Q_Q);
hold on
plot(ones(size(M.Est0_Q_Q,1),1)* DS.pdf.pdfs{2}.R(:)','--');

figure(2)
hold off
plot(M.Est0_apost_mean_);
hold on
plot(M.DS_x,'--');

