classdef mexDirac < mexEpdf
    % Dirac delta probability distribution
    properties
        point % point of the support
    end
    methods
        function m=mean(obj)
            m = obj.point;
        end
        function obj=validate(obj)
            % point should be a column
            if (size(obj.point,2)>1)
                if (size(obj.point,1)==1) % it is row
                    obj.point = obj.point';
                end
            else
                error('Point in mexDirac is not a vector');
            end
        end
        function dim=dimension(obj)
            dim = size(obj.point,1);
        end
        function v=variance(obj)
            v=zeros(size(obj.point));
        end
        function l=evallog(obj,x)
            if obj.point==x
                l = inf;
            else
                l=0;
            end
        end
        function s=sample(obj);
            s = obj.point;
        end
    end
end