/*!
\file
\brief wrapper function for enorm.bhattacharyya()


 */

#include <stat/emix.h>

using namespace bdm;

#ifdef MEX
#include <mex/mex_parser.h>

void mexFunction ( int n_output, mxArray *output[], int n_input, const mxArray *input[] ) {
	// Check the number of inputs and output arguments
	if ( n_input<2 ) mexErrMsgTxt ( "Usage:\n"
		                                "vec=enorm_bhattacharyya(enorm_struct, enorm_struct)\n"
		                                "  pdf_struct = struct('class','enorm<>',...);  % description of pdf\n"
		                                "output:\n"
		                                "  double Bhattacharia distance between arguments." );

	RV::clear_all();
	//CONFIG
	UImxArray E1(input[0]);
	UImxArray E2(input[0]);
// 	Cfg.writeFile("epdf_mean.cfg");

	double bht=-1.0;
	string cls= E1.getRoot()["class"];
	if (cls.find("ldmat")!=string::npos){
		shared_ptr<enorm<ldmat> > ep=UI::build<enorm<ldmat> >(E1);
		shared_ptr<enorm<ldmat> > ep2=UI::build<enorm<ldmat> >(E2);
		bht = ep->bhattacharyya(*ep2);
	}
	if (cls.find("fsqmat")!=string::npos){
		shared_ptr<enorm<fsqmat> > ep=UI::build<enorm<fsqmat> >(E1);
		shared_ptr<enorm<fsqmat> > ep2=UI::build<enorm<fsqmat> >(E2);
		bht = ep->bhattacharyya(*ep2);
	}
	if (cls.find("chmat")!=string::npos){
		shared_ptr<enorm<chmat> > ep=UI::build<enorm<chmat> >(E1);
		shared_ptr<enorm<chmat> > ep2=UI::build<enorm<chmat> >(E2);
		bht = ep->bhattacharyya(*ep2);
	}
	
	if (bht>-1.0){	
		//if ( n_output<1 ) mexErrMsgTxt ( "No output - nothing to do!" );
		output[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
		double2mxArray(bht, output[0]);
	} else { 
		mexErrMsgTxt ( "Given objects ar not of the same type" );
	}
}
#endif
