function [box zero range eigvec]=make_box3(points)
eps=10^-2;
%OK

N=size(points,1);
dim=size(points,2);
num_of_points=round(N^(1/dim));

meanval=min(mean(points,1),1-2*eps);
medianval=2*(median(abs(points-ones(N,1)*meanval),1));
eigvec=eye(dim);

%range=1.5*sqrt(diag(eigval)/N);
%pom=points*eigvec/2;
%range=min((max(pom)-min(pom))',range);
%range=(max(points)-min(points))';
range=min(medianval',min(1-eps-meanval',meanval'-eps));

box=zeros(N,dim);
pointer=-range;
step=2*range/(num_of_points-1);
jump=[1 num_of_points ];
for i=1:N
    for k=1:dim
        box(i,k)=pointer(k)+step(k)*mod(floor((i-1)/jump(k)),num_of_points);
    end
end  
box=box+ones(N,1)*(meanval.*[1 1]);
range=ones(dim,1)./(2*range);
if box(1,1)==0
    box=box+ones(N,1)*(eps*[1 0]);
end
if box(1,2)==0
    box=box+ones(N,1)*(eps*[0 1]);
end
zero=box(1,:);

%plot(box(:,1), box(:,2),'b.' ); hold on; plot(meanval(:,1), meanval(:,2), 'g+' );plot(points(:,1), points(:,2), 'r.' ); hold off
end