#!/usr/bin/perl -w

use strict;
use warnings;

use English qw( -no_match_vars );
use Carp;

while (<>) {
    my $filename = $_;
    $filename =~ s/ *(.*?) */$1/; #trim
    $filename =~ s/bdm::/classbdm_1_1/;
    $filename =~ s/$/.html/;
    print "html/" . $filename;
}


__END__

=head1 NAME

filename.pl -- one line description

=head1 USAGE

./filename.pl [options]

Options:

=over

=item C<--option>

Option description

=back

=head1 DESCRIPTION

=head1 DEPENDENCIES

=head1 AUTHOR

Miroslav Tynovsky

=cut


