pdfs; % load example pdfs

f1=N1a;
f2=N2a;
f3=Ga;

% merger 
Merger.class='merger_base';
Merger.beta=1;

% support
support.class='rectangular_support';
support.ranges={[-5,5]};
support.gridsizes=[100];

% 1D
Merger.method='arithmetic';
[vy]=merger({f1,f2},support,Merger)
    figure(1)
    subplot(1,3,1);
    hold off
    plot(vy.support,vy.weights,'-')
    hold on
    plot(vy.support,vy.source1,'--')
    plot(vy.support,vy.source2,'--')

Merger.method='lognormal';
[vy]=merger({f1,f3},support,Merger)
    subplot(1,3,2);
    hold off
    plot(vy.support,vy.weights,'-')
    hold on
    plot(vy.support,vy.source1,'--')
    plot(vy.support,vy.source2,'--')

Merger.method='geometric';
[vy]=merger({f1,f2},support,Merger)
    subplot(1,3,3);
    hold off
    plot(vy.support,vy.weights,'-')
    hold on
    plot(vy.support,vy.source1,'--')
    plot(vy.support,vy.source2,'--')

%%
f3=Nab;
f4=GiW;

% 2D support
type=1;
if type==0
    support2.class='rectangular_support';
    support2.ranges={[-5,5],[0.001,5]};
    support2.gridsizes=[10,10];
else
    support2.class='discrete_support';
    support2.epdf= struct('class','enorm<ldmat>','mu',[1,2],'R',[2 0; 0 2]);
    support2.npoints=[100];
end    

% 2D
vy2=merger({f3,f4},support2,Merger)

if type==0
    X=zeros(support2.gridsizes(1));
    Y=zeros(support2.gridsizes(1));
    Z=zeros(support2.gridsizes(1));

    X(:)=vy2.support(1,:);
    Y(:)=vy2.support(2,:);
    Z(:)=vy2.weights(:);
    
    figure(2);
    subplot(1,3,1);
    contour(X,Y,Z);
    subplot(1,3,2);
    Z(:)=vy2.source1(:);
    contour(X,Y,Z,'--');
    subplot(1,3,3);
    Z(:)=vy2.source2(:);
    contour(X,Y,Z,'--');
else
    figure(2);
    subplot(1,3,1);
    hold off
    plot(vy2.support(1,:),vy2.support(2,:),'.','MarkerSize',4)
    hold on
    contour_2(vy2.support(1,:),vy2.support(2,:),vy2.weights)
    subplot(1,3,2);
    contour_2(vy2.support(1,:),vy2.support(2,:),vy2.source1)
    subplot(1,3,3);
    contour_2(vy2.support(1,:),vy2.support(2,:),vy2.source2)
end
